-- Messaging for Buzz Applicant Appointment - Parent Event (vettori Sprint)

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='APPOINTMENT');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`,`uiDisplayCode`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'BUZZ_APPLICANT_PARENT_APPOINTMENT', 'Buzz Applicant Appointment - Parent', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Buzz Applicant Appointment - Parent','Buzz Applicant Appointment - Parent');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BUZZ_APPLICANT_PARENT_APPOINTMENT_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BUZZ_APPLICANT_PARENT_APPOINTMENT_RECIPIENT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BUZZ_APPLICANT_PARENT_APPOINTMENT_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'BUZZ_APPLICANT_PARENT_APPOINTMENT_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BUZZ_APPLICANT_PARENT_APPOINTMENT_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='BUZZ_APPLICANT_PARENT_APPOINTMENT_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BUZZ_APPLICANT_PARENT_APPOINTMENT_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId, "SELECT 
    T1.id AS USER_ID
FROM
    sg_appointment T1
WHERE
    T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BUZZ_APPLICANT_PARENT_APPOINTMENT_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.id AS ID,
    app.code  AS APPLICANT_CODE,
    T4.firstName AS FIRST_NAME,
    T4.lastName AS LAST_NAME,
	T2.firstName AS APPLICANT_FIRST_NAME,
    T2.lastName AS APPLICANT_LAST_NAME,
    T4.emailId AS EMAIL_ID,
    T4.mobileCountryCode AS MOBILE_CODE,
    T4.mobileNumber AS MOBILE_NO,
    T6.applicationCreatedOn AS APPLICATION_DATE,
    (CASE
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'APPLIED'
        THEN
            'Applied'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'NOT_APPLIED'
        THEN
            'Not Applied'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'SOLD'
        THEN
            'Sold'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'SUBMITTED'
        THEN
            'Submitted'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'DIRECT_ADMISSION'
        THEN
            'Direct Admission'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'MID_TERM_ADMISSION'
        THEN
            'Mid term admission'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'DIRECT_SUBMISSION_TOKEN_GENERATED'
        THEN
            'Direct submission token generated'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'FORM_SALE_TOKEN_GENERATED'
        THEN
            'Form sale token generated'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'NOT_SUBMITTED'
        THEN
            'Not Submitted'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ADMISSION_GRANTED'
        THEN
            'Admission granted'
        ELSE ''
    END) AS APPLICATION_STATUS,
    (CASE
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_LETTER_ACCEPTED'
        THEN
            'Offer letter accepted'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_LETTER_ISSUED'
        THEN
            'Offer letter issued'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_LETTER_REJECTED'
        THEN
            'Offer letter rejected'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_LETTER_DUE'
        THEN
            'Offer letter due'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'ACTIVE'
        THEN
            'Active'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'ADMITTED'
        THEN
            'Admitted'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'ADMITTED_ON_TRIAL'
        THEN
            'Admitted on trial'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'ADMITTED_ON_PROVISIONAL'
        THEN
            'Admitted on provisional'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'
        THEN
            'Withdrawn after accepting offer letter'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'PROVISIONAL_OFFER_ISSUED'
        THEN
            'Provisional offer issued'
            WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'PROVISIONAL_OFFER_REJECTED'
        THEN
            'Provisional offer rejected'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'PROVISIONAL_OFFER_DUE'
        THEN
            'Provisional offer due'
        WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'OFFER_EXPIRED'
        THEN
            'Offer Expired'
            WHEN
            T7.currentStatus IS NOT NULL
                AND T7.currentStatus = 'PROVISIONAL_OFFER_EXPIRED'
        THEN
            'Provisional Offer Expired'
        ELSE ''
    END) AS OFFER_STATUS,
     group_concat(T9.programName SEPARATOR ',') as PROGRAM_NAME,
     group_concat(T10.batchName SEPARATOR ',') as BATCH_PRINT_NAME,
     group_concat(T11.seatName SEPARATOR ',') as SEAT_TYPE,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
	T5.salutationName AS SALUTATION_NAME,
	T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    T12.id AS ACADEMY_LOCATION_ID,
    T12.academyId AS ACADEMY_ID,
    concat(T15.phoneCountryCode, '-',T15.phoneAreaCode,'-',T15.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
	T15.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
	T15.websiteURL AS ACADEMY_LOCATION_URL,
    (CASE
        WHEN
            T12.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T12.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
	(CASE
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T12.logoUrl)
    END) AS LOGO_URL
FROM
    `sg_appointment` T1
     LEFT JOIN
    application app ON app.id = T1.applicationId
        LEFT JOIN
    applicant_person T2 ON T2.id = app.applicantPersonId
        INNER JOIN
    applicant_person_relationships T3 ON T3.applicantPersonId = T2.id
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.relatedApplicantPersonId
    LEFT JOIN
    salutations T5 on T5.id=T4.salutationId
    left join
    application T6 on T6.id=T1.applicationId
    left join
    application_program T7 on T7.applicationId=T6.id  
    left join
    prog_batch_seat_config T8 on T8.id=T7.progBatchSeatConfigId
    left join
    programs T9 on T9.id=T7.programId
    left join
    batches T10 on T10.id=T8.programBatchId
     left join
    seat_types T11 on T11.id=T8.seatTypeId
    left join
    academy_location T12 on T12.id=T1.academyLocationId
     left join
    sg_visit_status T13 on T13.id=T1.visitStatusId
     left join
    academy_location_addresses T14 on T14.academyLocationId=T12.id
     inner join
    address T15 on T15.id=T14.addressId and T15.addressTypeId=10
    
       LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams) and T3.relationship = 'FATHER' ",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "firstName",
            "resultKey": "APPLICANT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "batchPrintName",
            "resultKey": "BATCH_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "seatType",
            "resultKey": "SEAT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "applicationStatus",
            "resultKey": "APPLICATION_STATUS",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "offerStatus",
            "resultKey": "OFFER_STATUS",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "applicationDate",
            "resultKey": "APPLICATION_DATE",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "logoURL",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "academyLocationId",
            "resultKey": "ACADEMY_LOCATION_ID",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "academyId",
            "resultKey": "ACADEMY_ID",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "appointmentDate",
            "resultKey": "APPOINTMENT_DATE",
            "displayCode": "",
            "displayOrder": 18
        },
        {
            "id": 20,
            "value": "visitTime",
            "resultKey": "VISIT_TIME",
            "displayCode": "",
            "displayOrder": 19
        },
        {
            "id": 21,
            "value": "lastName",
            "resultKey": "APPLICANT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 20
        },
        {
            "id": 22,
            "value": "phoneNo",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 21
        },
        {
            "id": 23,
            "value": "websiteURL",
            "resultKey": "ACADEMY_LOCATION_URL",
            "displayCode": "",
            "displayOrder": 22
        }
    ]
}');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='BUZZ_APPLICANT_PARENT_APPOINTMENT');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPOINTMENT');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='BUZZ_APPLICANT_PARENT_APPOINTMENT_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Buzz Applicant Appointment Booked - Parents',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Buzz Applicant Appointment Booked - Parents',NULL,'',NULL,'','APPROVED','','1','System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','APPOINTMENT SCHEDULED','<html>
<head>
    <title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
    <tbody>
        <tr style="background-color:#f0f0f0; height:120px;">
            <td align="center" style="margin:0px;"><img height="120" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
        </tr>
        <tr style="background-color:#f0f0f0; line-height:20px;">
            <td style="padding:20px 20px 20px 20px;">


            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong>, please note that <strong>$recipientData[&quot;APPLICANT_FIRST_NAME&quot;] $recipientData[&quot;APPLICANT_LAST_NAME&quot;]</strong> has booked an appointment on <strong>$recipientData[&quot;APPOINTMENT_DATE&quot;]</strong> and <strong>$recipientData[&quot;VISIT_TIME&quot;]</strong> with <strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong>, which you are welcome to attend.</p>
            
             
             <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">If you have any questions, please contact us on <strong>$recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;]</strong> or <strong>$recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]</strong>, alternatively visit our website <strong>$recipientData[&quot;ACADEMY_LOCATION_URL&quot;]</strong>.</p>

            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><br/>
Kind regards, <br/><br/>
<strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong><br/>
$recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]<br/>
$recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;]<br/>
$recipientData[&quot;ACADEMY_LOCATION_URL&quot;]</span></span></p>
            </td>
        </tr>
        <tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
        </tr>
    </tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"], please note that $recipientData["APPLICANT_FIRST_NAME"] $recipientData["APPLICANT_LAST_NAME"] has booked an appointment on $recipientData["APPOINTMENT_DATE"] and $recipientData["VISIT_TIME"] with $recipientData["ACADEMY_NAME"], which you are welcome to attend.

If you have any questions, please contact us using the details below.
Kind regards,

$recipientData["ACADEMY_NAME_LOCATION"]
$recipientData["ACADEMY_LOCATION_EMAIL_ID"]
$recipientData["ACADEMY_LOCATION_PHONE_NO"]
$recipientData["ACADEMY_LOCATION_URL"]');


set sql_safe_updates=0;
update msg_template_config set templatelanguageValue= 'English' where templatelanguageValue is null;
update msg_template_config set whetherEnabled=1 where whetherEnabled is null;
set sql_safe_updates=1;

-- End Messaging for Buzz Applicant Appointment - Parent Event 
